# 画面設計書 13-Login Page

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）におけるLogin Page画面（Page 9999）の設計書である。ユーザー認証を行うためのログイン画面について、その構成、機能、データフローを定義する。

### 本画面の処理概要

本画面は、QUASTOアプリケーションへのアクセスを認証するためのログイン画面である。ユーザー名とパスワードを入力し、認証が成功するとDashboard画面へ遷移する。

**業務上の目的・背景**：QUASTOは品質管理ルールを定義・実行・管理するシステムであり、セキュリティ上の観点から認証済みユーザーのみがアクセスできる必要がある。本画面はOracle APEX標準の認証機構（APEX_AUTHENTICATION）を使用し、ワークスペース内のユーザーアカウントによる認証を提供する。また、ユーザービリティ向上のため「Remember username」機能を備え、再ログイン時の入力負担を軽減する。

**画面へのアクセス方法**：
- アプリケーションURLに直接アクセスした際、未認証の場合は自動的に本画面にリダイレクト
- セッションタイムアウト後に自動的にリダイレクト
- 明示的にログアウトした後に表示

**主要な操作・処理内容**：
1. Usernameフィールドにユーザー名を入力
2. Passwordフィールドにパスワードを入力
3. 「Remember username」チェックボックスを任意で選択（次回ログイン時にユーザー名を記憶）
4. Sign Inボタンをクリックして認証を実行
5. 認証成功時はDashboard画面（Page 1）へ遷移

**画面遷移**：
- 遷移元：未認証状態での任意のページアクセス、セッションタイムアウト
- 遷移先：Dashboard画面（Page 1）（認証成功時）

**権限による表示制御**：本画面は公開ページ（p_page_is_public_y_n=>'Y'）として設定されており、認証前にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | QUASTOインストール | 遷移先機能 | ログイン成功後にQUASTOダッシュボードへ遷移 |

## 画面種別

認証ページ（ログイン）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| Page ID | 9999 |
| Page Alias | LOGIN |
| Step Title | QUASTO - Log In |
| Page Is Public | Yes |
| URL形式 | `f?p=141:LOGIN:&SESSION.` または `f?p=141:9999:&SESSION.` |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | 表示タイプ | 最大長 | 説明 |
|--------|--------|----------|------|------------|--------|------|
| Username | P9999_USERNAME | VARCHAR2 | Yes | Text Field | 100 | ユーザー名入力フィールド |
| Password | P9999_PASSWORD | VARCHAR2 | Yes | Password | 100 | パスワード入力フィールド（マスク表示） |
| Remember username | P9999_REMEMBER | VARCHAR2 | No | Single Checkbox | - | ユーザー名をCookieに保存するかどうか |

### 項目詳細

#### P9999_USERNAME

| 属性 | 値 |
|------|-----|
| Item Sequence | 10 |
| Placeholder | Username |
| Icon CSS Classes | fa-user |
| Size | 40 |
| Max Length | 100 |
| Is Persistent | N |
| Autocomplete | OFF |

#### P9999_PASSWORD

| 属性 | 値 |
|------|-----|
| Item Sequence | 20 |
| Placeholder | Password |
| Icon CSS Classes | fa-key |
| Size | 40 |
| Max Length | 100 |
| Is Persistent | N |
| Submit When Enter Pressed | Y |

#### P9999_REMEMBER

| 属性 | 値 |
|------|-----|
| Item Sequence | 30 |
| Display When | apex_authentication.persistent_cookies_enabled |
| Display When Type | EXPRESSION (PL/SQL) |

## 表示項目

### QUASTOリージョン

| 要素 | 説明 |
|------|------|
| Region Image | `#APP_FILES#icons/app-icon-512.png` |
| Region Name | QUASTO |
| ユーザー名フィールド | アイコン付きテキストフィールド |
| パスワードフィールド | アイコン付きパスワードフィールド |
| Remember usernameチェックボックス | 条件付き表示 |
| Sign Inボタン | ホットボタン（プライマリアクション） |

## イベント仕様

### 1-Sign Inボタン押下

**トリガー**：Sign Inボタンのクリック、またはパスワードフィールドでのEnterキー押下

**処理フロー**：
1. フォームをサブミット
2. AFTER_SUBMITプロセス「Set Username Cookie」が実行
3. AFTER_SUBMITプロセス「Login」が実行
4. AFTER_SUBMITプロセス「Clear Page(s) Cache」が実行
5. 認証成功時：Dashboard画面（Page 1）へリダイレクト
6. 認証失敗時：エラーメッセージをインライン表示

**データの流れ**：
```
[P9999_USERNAME, P9999_PASSWORD, P9999_REMEMBER]
    |
    v
[Process: Set Username Cookie] (sequence 10)
    │
    └─ APEX_AUTHENTICATION.SEND_LOGIN_USERNAME_COOKIE
           ├─ p_username => lower(:P9999_USERNAME)
           └─ p_consent => :P9999_REMEMBER
    |
    v
[Process: Login] (sequence 20)
    │
    └─ APEX_AUTHENTICATION.LOGIN
           ├─ p_username => :P9999_USERNAME
           ├─ p_password => :P9999_PASSWORD
           └─ p_set_persistent_auth => API_DEFAULT
    |
    v
[Process: Clear Page(s) Cache] (sequence 30)
    │
    └─ NATIVE_SESSION_STATE.CLEAR_CACHE_CURRENT_PAGE
    |
    v
[認証成功] --> [Dashboard Page 1]
```

### 2-ページ表示時（BEFORE_HEADER）

**処理フロー**：
1. BEFORE_HEADERプロセス「Get Username Cookie」が実行
2. Cookieからユーザー名を取得してP9999_USERNAMEにセット
3. ユーザー名が存在する場合、P9999_REMEMBERを'Y'にセット

**データの流れ**：
```
[Cookie]
    │
    └─ APEX_AUTHENTICATION.GET_LOGIN_USERNAME_COOKIE
           │
           ▼
    P9999_USERNAME := (Cookie値)
    P9999_REMEMBER := CASE WHEN P9999_USERNAME IS NOT NULL THEN 'Y' END
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Sign Inボタン押下 | APEX内部テーブル（セッション管理） | INSERT/UPDATE | APEXセッション作成・更新 |
| Remember username有効時 | なし（Cookieベース） | - | ブラウザCookieにユーザー名保存 |

### 認証メカニズム

| 項目 | 説明 |
|------|------|
| 認証スキーム | Oracle APEX標準認証（APEX_AUTHENTICATION） |
| 認証対象 | APEXワークスペース内のユーザーアカウント |
| セッション管理 | APEX標準セッション管理 |
| Cookie | persistent_auth_cookie（Remember me機能使用時） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | エラー | Invalid Login Credentials | ユーザー名またはパスワードが不正 |
| MSG-002 | エラー | Account Locked | アカウントがロック状態 |
| MSG-003 | エラー | Session Expired | セッションタイムアウト後の再認証要求 |

## 例外処理

| 例外パターン | 発生条件 | 画面の挙動 |
|-------------|---------|------------|
| 認証失敗 | ユーザー名/パスワード不一致 | INLINE_IN_NOTIFICATIONでエラー表示、ページ再表示 |
| アカウントロック | 連続認証失敗によるロック | エラーメッセージ表示 |
| APEX認証サービスエラー | 内部エラー | ORA-エラー表示 |

## 備考

- Page Template: Login Page専用テンプレート（p_step_template参照）
- Autocomplete: OFF設定（ブラウザ自動補完を抑制）
- First Item: AUTO_FIRST_ITEM（ページ表示時に最初の入力項目にフォーカス）
- Warn On Unsaved Changes: N（未保存警告を無効化）
- Remember username機能は`apex_authentication.persistent_cookies_enabled`が有効な場合のみ表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はデータベーステーブルを直接操作しないが、APEX認証メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | APEX_AUTHENTICATION パッケージ | （Oracle内部） | LOGIN, SEND_LOGIN_USERNAME_COOKIE, GET_LOGIN_USERNAME_COOKIE関数の理解 |

**読解のコツ**: APEX_AUTHENTICATIONはOracle APEX標準パッケージであり、ワークスペースユーザーの認証を提供する。詳細はOracle APEX APIリファレンスを参照。

#### Step 2: エントリーポイントを理解する

画面定義ファイルでUI構成とプロセス定義を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_09999.sql | `src/apex/f141/application/pages/page_09999.sql` | ページ定義、入力項目定義、プロセス定義 |

**主要処理フロー**:
1. **行14-27**: ページ基本定義（公開ページ、Loginテンプレート）
2. **行28-39**: QUASTOリージョン定義（アプリアイコン表示）
3. **行40-54**: Sign Inボタン定義（ホットボタン）
4. **行55-75**: P9999_USERNAMEフィールド定義
5. **行76-92**: P9999_PASSWORDフィールド定義
6. **行93-108**: P9999_REMEMBERチェックボックス定義
7. **行109-145**: Set Username Cookieプロセス（NATIVE_INVOKE_API）
8. **行146-192**: Loginプロセス（NATIVE_INVOKE_API）
9. **行193-202**: Clear Page(s) Cacheプロセス
10. **行203-214**: Get Username Cookieプロセス（BEFORE_HEADER）

#### Step 3: 認証フローを理解する

APEX認証の全体フローを把握する。

| 順序 | 処理 | 説明 |
|-----|------|------|
| 3-1 | BEFORE_HEADER | Get Username Cookie - 保存済みユーザー名をCookieから取得 |
| 3-2 | ページ表示 | ユーザー入力待ち |
| 3-3 | AFTER_SUBMIT (seq 10) | Set Username Cookie - ユーザー名をCookieに保存 |
| 3-4 | AFTER_SUBMIT (seq 20) | Login - 認証実行、セッション作成 |
| 3-5 | AFTER_SUBMIT (seq 30) | Clear Cache - ページキャッシュクリア |
| 3-6 | リダイレクト | 認証成功時、Home Page（Dashboard）へ遷移 |

### プログラム呼び出し階層図

```
[Page 9999: Login Page]
    │
    ├─ [BEFORE_HEADER]
    │      │
    │      └─ [Process: Get Username Cookie]
    │             │
    │             └─ APEX_AUTHENTICATION.GET_LOGIN_USERNAME_COOKIE
    │                    │
    │                    ▼
    │             :P9999_USERNAME := (Cookie値)
    │             :P9999_REMEMBER := CASE...
    │
    ├─ [ページ表示]
    │      │
    │      └─ [QUASTO Region]
    │             ├─ P9999_USERNAME (Text Field)
    │             ├─ P9999_PASSWORD (Password)
    │             ├─ P9999_REMEMBER (Checkbox, 条件表示)
    │             └─ LOGIN Button (Sign In)
    │
    └─ [AFTER_SUBMIT]
           │
           ├─ [Process: Set Username Cookie] (seq 10)
           │      │
           │      └─ APEX_AUTHENTICATION.SEND_LOGIN_USERNAME_COOKIE
           │             ├─ p_username => lower(:P9999_USERNAME)
           │             └─ p_consent => :P9999_REMEMBER
           │
           ├─ [Process: Login] (seq 20)
           │      │
           │      └─ APEX_AUTHENTICATION.LOGIN
           │             ├─ p_username => :P9999_USERNAME
           │             ├─ p_password => :P9999_PASSWORD
           │             └─ p_set_persistent_auth => (default)
           │             │
           │             └─ [認証成功] --> セッション作成
           │
           └─ [Process: Clear Page(s) Cache] (seq 30)
                  │
                  └─ NATIVE_SESSION_STATE.CLEAR_CACHE_CURRENT_PAGE
                         │
                         └─ [Dashboard Page 1 へリダイレクト]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

                    [BEFORE_HEADER]
Browser Cookie ───▶ GET_LOGIN_USERNAME_COOKIE ───▶ P9999_USERNAME
                                              ───▶ P9999_REMEMBER

                    [AFTER_SUBMIT]
P9999_USERNAME ───┐
P9999_REMEMBER ───┼──▶ SEND_LOGIN_USERNAME_COOKIE ───▶ Browser Cookie
                  │
P9999_USERNAME ───┤
P9999_PASSWORD ───┴──▶ APEX_AUTHENTICATION.LOGIN
                              │
                              ├─ [成功] ──▶ APEX Session ──▶ Dashboard
                              │
                              └─ [失敗] ──▶ Error Message ──▶ Login Page
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_09999.sql | `src/apex/f141/application/pages/page_09999.sql` | ソース | 画面定義（APEX Page） |
| app-icon-512.png | `#APP_FILES#icons/app-icon-512.png` | 画像 | ログイン画面のアプリアイコン |
| APEX_AUTHENTICATION | （Oracle内部パッケージ） | API | 認証処理を提供するAPEX標準API |
